package org.msh.tb.entities;

import org.hibernate.validator.NotNull;
import org.msh.tb.application.tasks.TaskStatus;

import javax.persistence.*;
import java.util.Date;

/**
 * Created by rmemoria on 14/7/17.
 */
@Entity
@Table(name = "tasklog")
public class TaskLog {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Integer id;

    @NotNull
    private String taskId;

    @NotNull
    private String taskClass;

    @NotNull
    @Enumerated(EnumType.STRING)
    private TaskStatus status;

    @Temporal(TemporalType.TIMESTAMP)
    @NotNull
    private Date execStart;

    @Temporal(TemporalType.TIMESTAMP)
    @NotNull
    private Date execEnd;

    @Lob
    private String data;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getTaskClass() {
        return taskClass;
    }

    public void setTaskClass(String taskClass) {
        this.taskClass = taskClass;
    }

    public Date getExecStart() {
        return execStart;
    }

    public void setExecStart(Date execStart) {
        this.execStart = execStart;
    }

    public Date getExecEnd() {
        return execEnd;
    }

    public void setExecEnd(Date execEnd) {
        this.execEnd = execEnd;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public TaskStatus getStatus() {
        return status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }
}